﻿' 版权所有 (C) Microsoft Corporation。保留所有权利。
Public Class MainForm

    Private Sub CurrentProcessInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCurrentProcessInfo.Click
        ' 演示如何检索有关当前进程的信息。
        Dim curProc As Process = Process.GetCurrentProcess()

        Dim description As String = "The total working set of the current process is: " + _
                curProc.WorkingSet64.ToString() + vbCrLf

        description += "The minimum working set of the current process is: " + _
                curProc.MinWorkingSet.ToString() + vbCrLf

        description += "The max working set of the current process is: " + _
                curProc.MaxWorkingSet.ToString() + vbCrLf

        description += "The start time of the current process is: " + _
                curProc.StartTime.ToLongTimeString() + vbCrLf

        description += "The processor time used by the current process is: " + _
        curProc.TotalProcessorTime.ToString() + vbCrLf

        DisplayText.Text = description
    End Sub

    Private Sub btnStartProcess_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnStartProcess.Click
        ' 使用进程类启动进程的简单演示。
        Process.Start("notepad.exe")
    End Sub

    Private Sub btnProcessStartInfo_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnProcessStartInfo.Click
        ' 使用 StartInfo 对象可以在启动应用程序前向其传递 
        ' 其他参数。在本例中，设置了应用程序的默认窗口状态。
        Dim startInfo As New ProcessStartInfo("notepad.exe")
        startInfo.WindowStyle = ProcessWindowStyle.Maximized
        Process.Start(startInfo)
    End Sub

    Private Sub btnTaskManager_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnTaskManager.Click
        ' 使用进程类可以访问附加信息（如由进程
        ' 加载的模块）。此代码显示的窗体对此进行了演示。
        Dim manager As New TaskManager()
        manager.Show()
    End Sub

    Private Sub btnShellExecute_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnShellExecute.Click

        If Not System.IO.File.Exists("c:\demofile_shell.txt") Then
            Dim sw As New System.IO.StreamWriter("c:\demofile_shell.txt")
            sw.WriteLine("Shell Execute Demo")
            sw.Close()
        End If

        ' StartInfo 类还可以用于指定希望由操作系统外壳程序 
        ' 执行进程。这意味着可以传递具有操作系统已知
        ' 的扩展名的文件名，并且操作系统会启动适当的
        ' 应用程序类型。
        Dim startInfo As New ProcessStartInfo("c:\demofile_shell.txt")
        ' UseShellExecute 的默认值为 false。如果
        ' 此值未设置，则会在执行启动方法时引发异常。
        startInfo.UseShellExecute = True
        Process.Start(startInfo)

    End Sub

    Private Sub btnCommandLine_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles btnCommandLine.Click
        ' 用两个不同的命令行参数启动 Windows 资源管理器。
        Dim startInfo As New ProcessStartInfo("explorer.exe")
        ' 为默认选择打开一个新的单窗格窗口。 
        ' 这通常是安装 Windows 的驱动器的根目录。 
        startInfo.Arguments = "/n"
        Process.Start(startInfo)
    End Sub


    Private Sub exitToolStripMenuItem_Click(ByVal sender As System.Object, ByVal e As System.EventArgs) Handles exitToolStripMenuItem.Click
        Me.Close()
    End Sub
End Class
